// Copyright © 2025 Murat Kalinyaprak
// Shared under the terms of GNU General Public License.

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <time.h>

int seed, die1, die2, dice, i, rolls, tally;
int counts[36] = {0};
int pairs[36] = {11, 12, 13, 14, 15, 16, 21, 22, 23, 24, 25, 26, 31, 32, 33, 34, 35, 36,
41, 42, 43, 44, 45, 46, 51, 52, 53, 54, 55, 56, 61, 62, 63, 64, 65, 66};
float pct, pcts;
FILE *dicef, *statf;
float avrg = (float)2.7777;

int main() {

printf ("Enter number of rolls: ");
scanf ("%d", &rolls);

printf ("Enter seed or blank for time: ");
scanf ("%d", &seed);

dicef = fopen("dicefile.txt", "w");

if (dicef == NULL) {
	printf ("Can't open dice file\n");
	getch ();
	exit (0);
}

statf = fopen("statfile.txt", "w");

if (statf == NULL) {
	printf ("Can't open stat file\n");
	getch ();
	exit (0);
}

fprintf (statf, "Number of rolls: %d \n", rolls);
fprintf (statf, "Seed: %d \n", seed);

if (seed == 0) {
	seed = (time(NULL));
	fprintf (statf, "Time: %d \n", seed);
}

srand(seed);
fprintf (statf, "\n");

for (i = 0; i < rolls;) {  
	dice = rand();
	dice = (dice % 36);
	fprintf (dicef, "%d ", pairs[dice], " ");
	counts [dice]++;
	i++;
}

for (i = 0; i < 36;) {
	pct = (counts[i]*100)/(float)rolls;
	fprintf (statf, "%d %d %2.4f %+2.4f", pairs[i], counts[i], pct, pct-avrg);
	if (pct > 2.8749 || pct < 2.6805) {
		fprintf (statf, " !!");
	}
	fprintf (statf, "\n");
	tally = tally + counts[i];
	pcts = pcts + pct;
	i++;
}
fprintf (statf, "\n");
fprintf (statf, "Totals: %d %2.4f \n", tally, pcts);

fclose (dicef);
fclose (statf);
}
